/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Operations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class Drawing {
    public static int[] draw_scaled(BufferedImage dest, BufferedImage src) {
        double percentage = Drawing.subscribePercentage(dest, src);
        return Drawing.draw_scaled(dest, src, percentage);
    }

    public static int[] draw_scaled(BufferedImage dest, BufferedImage src, double percentage) {
        return Drawing.draw_scaled(dest, src, percentage, true);
    }

    public static int[] draw_scaled(BufferedImage dest, BufferedImage src, double percentage, boolean draw_black_borders) {
        int x_half = dest.getWidth() / 2;
        int y_half = dest.getHeight() / 2;
        int x1 = x_half - (int)((double)src.getWidth() * percentage / 2.0);
        int y1 = y_half - (int)((double)src.getHeight() * percentage / 2.0);
        int x2 = x_half + (int)((double)src.getWidth() * percentage / 2.0);
        int y2 = y_half + (int)((double)src.getHeight() * percentage / 2.0);
        Graphics g = dest.getGraphics();
        g.drawImage(src, x1, y1, x2, y2, 0, 0, src.getWidth(), src.getHeight(), null);
        if (draw_black_borders) {
            g.setColor(Color.black);
            g.fillRect(0, 0, dest.getWidth(), y1);
            g.fillRect(0, y2, dest.getWidth(), y1);
            g.fillRect(0, 0, x1, dest.getHeight());
            g.fillRect(x2, 0, x1, dest.getHeight());
        }
        int[] result = new int[]{x1, y1, x2, y2};
        return result;
    }

    public static int[] draw_scaled(Graphics g, int w, int h, BufferedImage src) {
        return Drawing.draw_scaled(g, w, h, src, Drawing.subscribePercentage(new Dimension(w, h), Drawing.toDim(src)));
    }

    public static int[] draw_scaled(Graphics g, int w, int h, BufferedImage src, double percentage) {
        int x_half = w / 2;
        int y_half = h / 2;
        int x1 = x_half - (int)((double)src.getWidth() * percentage / 2.0);
        int y1 = y_half - (int)((double)src.getHeight() * percentage / 2.0);
        int x2 = x_half + (int)((double)src.getWidth() * percentage / 2.0);
        int y2 = y_half + (int)((double)src.getHeight() * percentage / 2.0);
        g.drawImage(src, x1, y1, x2, y2, 0, 0, src.getWidth(), src.getHeight(), null);
        g.setColor(Color.black);
        g.fillRect(0, 0, w, y1);
        g.fillRect(0, y2, w, y1);
        g.fillRect(0, 0, x1, h);
        g.fillRect(x2, 0, x1, h);
        int[] result = new int[]{x1, y1, x2, y2};
        return result;
    }

    public static void draw_scaled(Graphics g, AffineTransform AT, int x, int y, BufferedImage src, int x_scale, int y_scale) {
        x = (int)((double)x + AT.getTranslateX());
        y = (int)((double)y + AT.getTranslateY());
        Drawing.draw_scaled(g, x, y, src, x_scale, y_scale);
    }

    public static void draw_scaled(Graphics g, int x, int y, BufferedImage src, int x_scale, int y_scale) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dx2 = x + sw * x_scale;
        int dy2 = y + sh * y_scale;
        g.drawImage(src, x, y, dx2, dy2, 0, 0, sw, sh, null);
    }

    public static void draw_sized(Graphics g, int x, int y, BufferedImage src, int w, int h) {
        g.drawImage(src, x, y, x + w, y + h, 0, 0, src.getWidth(), src.getHeight(), null);
    }

    private static double subscribePercentage(Dimension dest, Dimension src) {
        return Math.min(dest.getWidth() / src.getWidth(), dest.getHeight() / src.getHeight());
    }

    private static double superscribePercentage(Dimension dest, Dimension src) {
        return Drawing.subscribePercentage(src, dest);
    }

    private static double subscribePercentage(BufferedImage dest, BufferedImage src) {
        return Math.min(dest.getWidth() / src.getWidth(), dest.getHeight() / src.getHeight());
    }

    private static double superscribePercentage(BufferedImage dest, BufferedImage src) {
        return Drawing.subscribePercentage(src, dest);
    }

    private static Dimension toDim(BufferedImage i) {
        int w = i.getWidth();
        int h = i.getHeight();
        return new Dimension(w, h);
    }

    public static AffineTransform translate(AffineTransform AT, double tx, double ty) {
        AffineTransform result = new AffineTransform();
        result.setToTranslation(AT.getTranslateX() + tx, AT.getTranslateY() + ty);
        return result;
    }

    public static void copySrcIntoDstAt(BufferedImage src, BufferedImage dst, int dx, int dy) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = dx + dy * dst.getWidth();
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    public static void drawTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        int[] xs = new int[3];
        int[] ys = new int[3];
        xs[0] = x1;
        xs[1] = x2;
        xs[2] = x3;
        ys[0] = y1;
        ys[1] = y2;
        ys[2] = y3;
        g.fillPolygon(xs, ys, 3);
    }
}

